<?php
/**
 * @package		iCaptcha
 * @copyright	Copyright (C) 2006 - 2011 Ideal Extensions for Joomla. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

jimport('joomla.plugin.plugin');

/**
 * Plugin class for redirect handling.
 *
 * @package		Joomla
 * @subpackage	plgSystemRedirect
 */
class plgSystemIcaptcha extends JPlugin
{
	/**
	 * Object Constructor.
	 *
	 * @access	public
	 * @param	object	The object to observe -- event dispatcher.
	 * @param	object	The configuration object for the plugin.
	 * @return	void
	 * @since	1.0
	 */
	function __construct(&$subject, $config)
	{
		$this->session = JFactory::getSession();
		
		$lang = JFactory::getLanguage();
		$lang->load('plg_system_icaptcha',JPATH_ADMINISTRATOR);
		$lang->load('plg_system_icaptcha');
		$lang->load('plg_system_icaptcha',JPATH_SITE.'/plugins/system/icaptcha');
		
		parent::__construct($subject, $config);
	}
	
	public function onSubmitContact($params, $post) {
		if (JRequest::getVar('option') != 'com_contactenhanced'
			OR JRequest::getVar('option') != 'com_irecommend' 
		) {
			return '';
		}
		$params->set('displaySystemErrorMessage', true);
		return $this->onValidateForm($params);
	}
	
	function onAfterDisplayForm($param=null,$returnType='html') {
		if(is_object($param)){
			$this->params->merge($param);
		}
		
		$html	='';
		$user	= JFactory::getUser();
		if($this->params->get('only_non_registered') == 1 AND $user->id ){
			return $html;
		}
		if($this->params->get('captcha_systems') == 'recaptcha'){
			$html = $this->displayRecaptchaForm();
		}else if($this->params->get('captcha_systems') == 'mathguard'){
			$html = $this->displayMathGuardForm();
		}else if($this->params->get('captcha_systems') == 'vouchsafe'){
			$html = $this->displayVouchSafe();
		}else if($this->params->get('captcha_systems') == 'mollom'){
			$html = $this->displayMollom();
		}else{
			$html = $this->displaySecurImageForm();
		}
		$html = '<div class="captcha-container">'.$html.'</div>';
		//echo '<pre>'; print_r($this->params); echo '</pre>';
		
		if($returnType == 'html'){
			return $html;
		} 
		echo $html;
	}
	
	function onValidateForm($params,$returnType='html') {
		if (JRequest::getVar('option') == 'com_contactenhanced'
			OR JRequest::getVar('option') == 'com_irecommend' 
		) {
			$params->set('displaySystemErrorMessage', true);
		}
		
		$user	= JFactory::getUser();
		$app	= JFactory::getApplication();
		if( ($this->params->get('only_non_registered') == 1 AND $user->id) 
			OR defined('ICAPTCHA_RUN') 
			OR ($params->get( 'enable_captcha', 2) < 1  AND JUser::getInstance()->get('id') ) 
			OR $params->get( 'enable_captcha', 2) == 0
		){
			return true;
		}
		// @todo Find out why this function is called twice on form submission
		// Avoid this function to be called twice
		define('ICAPTCHA_RUN',1);
		
		
		$lang =JFactory::getLanguage();
		$lang->load('plg_system_icaptcha',JPATH_ADMINISTRATOR);
		
		if(is_object($params)){
			$this->params->merge($params);
		}
		//echo '<pre>'; print_r($args); echo '</pre>'; exit; 
		//echo $this->params->get('captcha_systems') ; exit;
		//echo 'Args: <pre>'; print_r(func_get_args()); echo '</pre>'; exit;
		$html	= '';
		
		if($this->params->get('captcha_systems') == 'recaptcha'){
			$html = $this->validateRecaptcha();
		}else if($this->params->get('captcha_systems') == 'mathguard'){
			$html = $this->validateMathGuard();
		}else if($this->params->get('captcha_systems') == 'vouchsafe'){
			$html = $this->validateVouchSafe();
		}else if($this->params->get('captcha_systems') == 'mollom'){
			$html = $this->validateMollom();
		}else{
			$html = $this->validateSecurImage();
		}
		
				//echo '<pre>'; print_r($_SESSION); exit;
		if($this->params->get('returnType') == 'boolean' OR $returnType == 'boolean'){
			if($this->params->get('displaySystemErrorMessage') AND !$html){
				$app->enqueueMessage(JText::_('ICAPTCHA_WRONG_VALIDATION_CODE'), 'error');
			}
			return $html;
		}else if(!$html){
			echo '<script>alert("'.JText::_('ICAPTCHA_WRONG_VALIDATION_CODE').'");history.back();</script>'; exit;
		}
		return $html;
	}
	
	
	function validateSecurImage(){
		
		require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/securImage/securimage.php');
		$securimage = new Securimage();
		// the code was incorrect
//		echo '<pre>'; print_r($_SESSION); exit;
		if($securimage->check(JRequest::getVar('captcha_code','','POST')) == false) {
			return false;
		}
		return true;
	}
	
	function validateMathGuard(){
		require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/mathguard/mathGuard.class.php');
		// the code was incorrect
		//Problem with the suffix
		if(mathGuardImproved::checkResult(JRequest::getVar('captcha_code','','POST'),$this->params->get('suffix')) == false) {
	//	if(mathGuardImproved::checkResult(JRequest::getVar('captcha_code','','POST'),	'') == false) {
			return false;
		}
		return true;
	}

	function validateRecaptcha(){
		if($this->params->get('captcha_systems-recaptcha-PriKey')){
			if(!defined('RECAPTCHA_API_SERVER')){
				require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/recaptchalib.php'); /**    reCAPTCHA Library   **/
			}
			$resp = recaptcha_check_answer ($this->params->get('captcha_systems-recaptcha-PriKey',''),
											$_SERVER["REMOTE_ADDR"],
											JRequest::getVar("recaptcha_challenge_field",null, "POST"),
											JRequest::getVar("recaptcha_response_field",null, "POST") );		
			if(!$resp->is_valid) {
				/*echo "\n recaptcha_challenge_field: ".JRequest::getString("recaptcha_challenge_field",null, "POST");
				echo "\n recaptcha_response_field: ".JRequest::getString("recaptcha_response_field",null, "POST");
				echo "\n";
				//print_r($_POST); exit;
				echo $resp->error;*/
				return false;
			}
		}
		return true;
	}
	
	function validateVouchSafe(){
		$challenge	= JRequest::getCmd("vouchsafe-challenge-id", JRequest::getCmd("vouchsafe-challenge-id", null, 'GET'), 'POST');
		$privatekey	= trim($this->params->get('captcha_systems-vouchsafe-PriKey')); // you got this from the signup page
		 
           
		if($privatekey AND $challenge){
			if(!function_exists('vouchsafe_check_answer')){
				/**    VouchSafe Library   **/
				require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/vouchsafe-lib.php'); 
			}
			// get user response
            $response = JRequest::getVar("vouchsafe-challenge-response", JRequest::getCmd("vouchsafe-challenge-response", null, 'GET'), 'POST');
            if ($response == null) {
                return false;
            }
			$serverToken =  JRequest::getVar("vouchsafe-server-token", JRequest::getCmd("vouchsafe-server-token", null, "GET"), "POST");
			$resp = vouchsafe_check_answer($privatekey, $challenge, $response, $serverToken);
			return $resp->is_valid;
		}
		return false;
	}
	
	
	function displaySecurImageForm(){
		$securImage_path	= '/plugins/system/icaptcha/captcha_systems/securImage/';
		$urlPath = JURI::base(true).$securImage_path;
		$doc =JFactory::getDocument();
		jimport('joomla.error.profiler');
		$iCaptchaId='captcha_code_'.JProfiler::getmicrotime();
		
		JHtml::_('behavior.framework', true);
		$javascript	= '';
		if(!defined('MULTIPLE_ENGINE_CAPTCHA_INSTANCE'))
		{
			define('MULTIPLE_ENGINE_CAPTCHA_INSTANCE',1);
			JText::script('ICAPTCHA_WRONG_VALIDATION_CODE');
			//$doc->addScript(JURI::root().'plugins/system/icaptcha/captcha_systems/securImage/securImage.js');
			/**/
			if(!class_exists('iBrowser')){
				require_once (JPATH_PLUGINS.'/system/icaptcha/helpers/browser.php');
			}
			$browser = new iBrowser();
			if($browser->getBrowser() == 'Internet Explorer' AND version_compare($browser->getVersion(), '9.0') <= 0){
				$doc->addScript($urlPath.'js/securImage-ie8.js');
			}else{
				$doc->addScript($urlPath.'js/securImage.js');
			}
			/**/
			$javascript	.= "
/* <![CDATA[ */
var icaptchaURI	= '".JURI::root(true)."/';
/* ]]> */
			";
			
		}
		$reloadLink	= '';
		if($this->params->get('captcha_systems-securImage-reloadbutton', 1)){
			$linkAttributes['onclick']	= 'updateCaptcha(); return false;';
			$linkAttributes['id']		= 'reloadImage';
			$linkAttributes['title']	= JText::_('ICAPTCHA_RELOAD_IMAGE_TITLE');
			$image	= JHTML::_('image','plugins/system/icaptcha/captcha_systems/securImage/images/reload/'.$this->params->get('captcha_systems-securImage-reloadimage', 'sync.png')
						,JText::_('ICAPTCHA_RELOAD_IMAGE')
						,'border="0"'
						, false);
			$reloadLink .= JHTML::_('link', JURI::current().'#'.JText::_('ICAPTCHA_RELOAD_IMAGE'),$image,$linkAttributes ); 
		}
		$html = '<br /><div class="securimage-container">';
		
			
			$image = JHTML::_('image','plugins/system/icaptcha/captcha_systems/securImage/show.php?sid='.md5(uniqid(time()))
						,JText::_('ICAPTCHA_IMAGE_ALT_TEXT')
						,'border="0" '
							.($this->params->get('captcha_systems-securImage-input-field-location') == 'right' ? ' align="left" ' : ' ') 
							. ' id="captcha'.$this->params->get('suffix','').'" '
							. ' name="captcha" '
						, false);
			//echo $securImage_path; exit;
			$html .= '
						<img '
							. ' src="'.JURI::root(true).'/plugins/system/icaptcha/captcha_systems/securImage/show.php?sid='.md5(uniqid(time())).'"'
							. ' border="0" '
							.($this->params->get('captcha_systems-securImage-input-field-location') == 'right' ? ' align="left"' : '')
							. ' id="captcha'.$this->params->get('suffix','').'"'
							. ' alt="'.JText::_('ICAPTCHA_IMAGE_ALT_TEXT').'"'
							. ' name="captcha" '
						.' />
						';
				//echo JURI::root(true); exit;
			if($this->params->get('captcha_systems-securImage-play-sound')){
				$html .= '<object type="application/x-shockwave-flash" data="'.$urlPath.'play.swf?audio_file='.$urlPath.'play.php&amp;bgColor1=#fff&amp;bgColor2=#fff&amp;iconColor=#777&amp;borderWidth=1&amp;borderColor=#000" height="32" width="32">
								<param name="movie" value="'.$urlPath.'play.swf?audio_file='.$urlPath.'play.php&amp;bgColor1=#fff&amp;bgColor2=#fff&amp;iconColor=#777&amp;borderWidth=1&amp;borderColor=#000">
				    </object> ';
			}
			$html .= $reloadLink; 
			$html .= '<div class="securimage-field-container">';
			$html .= '<label for="'.$iCaptchaId.'" class="requiredField securimage-label">'.JText::_('ICAPTCHA_VERIFICATION_CODE').': </label>';
			$html .= '<br />';
		
			$html .=  '<input type="text"
							autocomplete="off" 
							name="captcha_code" 
							id="'.$iCaptchaId.'" 
							class="inputbox captchacode required sicaptcha validate-sicaptcha" 
							size="12" maxlength="" />';
			$html .=  '<input type="hidden" name="captcha_code-validation" id="'.$iCaptchaId.'-validation"  />';
			$html .=  '<input type="hidden" name="captcha_code-icaptchaUseAjax" id="icaptchaUseAjax" 
							value="'.$this->params->get('captcha_systems-securImage-ajaxcheck',0).'" />';
			$html .= '</div>';
			$doc->addScriptDeclaration($javascript); //Conflicts with other extensions
			$html .= '<br /></div>';
			//$html .= '<pre>'. ceHelper::print_r($session->get('securimage_code_value')).'</pre>';  
		return $html;
	}

	function displayMathGuardForm(){
		require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/mathguard/mathGuard.class.php');
		
		$attributes		= array();
		$attributes['id']	= 'mathguard_answer'.$this->params->get('suffix');
		
		$html = '';
		$html .= '<label for="mathguard_answer'.$this->params->get('suffix').'" class="requiredField" id="label-mathguard_answer" >'
			.JText::_("ICAPTCHA_MATHGUARD_SECURITY_QUESTION").'</label>';
		$html .= '<br />';
		$html .= mathGuardImproved::returnQuestion($attributes,$this->params->get('suffix'));

		return $html;
	}
	

	function displayRecaptchaForm(){
		if($this->params->get('captcha_systems-recaptcha-PubKey')){
			$lang	= JFactory::getLanguage();
			$document	=JFactory::getDocument();
			$document->addScript('https://www.google.com/recaptcha/api/js/recaptcha_ajax.js');
			if(!defined('RECAPTCHA_API_SERVER')){
				require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/recaptchalib.php'); /**    reCAPTCHA Library   **/
			}
			$custom_translations ="";
			$langTag	= $this->params->get('captcha_systems-recaptcha-Lang','auto');
			
			if($langTag == 'auto'){
				$reCaptchaLanguage	= array(
									"nl-NL"	=>	"nl",
									"en-US"	=>	"en",
									"en-UK"	=>	"en",
									"en-AU"	=>	"en",
									"fr-FR"	=>	"fr",
									"de-CH"	=>	"de",
									"de-DE"	=>	"de",
									"pt-BR"	=>	"pt",
									"pt-PT"	=>	"pt",
									"es-AR"	=>	"es",
									"es-ES"	=>	"es",
									"tr-TR"	=>	"tr",
									"ru-RU"	=>	"ru"
								);
				if(array_key_exists($lang->getTag(),$reCaptchaLanguage)){
					
					$langTag	= $reCaptchaLanguage[$lang->getTag()];
				}else{
					$custom_translations	= 'custom_translations : {
	                        instructions_visual : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_INSTRUCTIONS_VISUAL").':",
	                        instructions_audio : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_INSTRUCTIONS_AUDIO").':",
	                        play_again : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_PLAY_AGAIN").'",
	                        cant_hear_this : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_CANT_HEAR_THIS").'",
	                        visual_challenge : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_VISUAL_CHALLENGE").'",
	                        audio_challenge : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_AUDIO_CHALLENGE").'",
	                        refresh_btn : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_REFRESH_BUTTON").'",
	                        help_btn : "'.JText::_("PLG_SYSTEM_ICAPTCHA_RECAPTCHA_HELP_BUTTON").'"
	                },
					';
					$langTag	= substr($lang->getTag(),0,2);
				}
			}
			
			$script		= 	"
window.addEvent('domready',function(){
	Recaptcha.create('".$this->params->get('captcha_systems-recaptcha-PubKey','')."',
		'icaptcha-recaptcha_div', 
		{	".$custom_translations
			."lang:'" .$langTag . "',
		  	 theme:'" . $this->params->get('captcha_systems-recaptcha-Theme','red') . "'
		});
});
";
			$document->addScriptDeclaration($script);
			
			/**   Generating CORE reCAPTCHA form   **/
			return '<div id="icaptcha-recaptcha_div"></div>'; 
		}else{
			return '<div id="icaptcha-recaptcha_div" ><strong>'.JText::_('PLG_SYSTEM_ICAPTCHA_RECAPTCHA_MISSING_PUBLIC_KEY').'</strong></div>';
		}
			
	}
	
	function displayVouchSafe(){
		$publickey = trim($this->params->get('captcha_systems-vouchsafe-PubKey')); // you got this from the signup page
		if($publickey){
			if(!function_exists('vouchsafe_check_answer')){
				/**    VouchSafe Library   **/
				require_once(JPATH_PLUGINS.'/system/icaptcha/captcha_systems/vouchsafe-lib.php'); 
			}
	        return vouchsafe_get_html($publickey);
			 
		}else{
			return '<div id="icaptcha-vouchsafe" ><strong>'.JText::_('PLG_SYSTEM_ICAPTCHA_VOUCHSAFE_MISSING_PUBLIC_KEY').'</strong></div>';
		}
			
	}
	
}