<?php
/**
 * @package		com_contactenhanced
* @copyright	Copyright (C) 2006 - 2013 Ideal Extensions for Joomla
 * @author     	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * HTML View class for the Contact component
 *
 * @since		1.5
 */
class ContactenhancedViewTools extends JView
{
	/**
	 * Display the view
	 */
	function display($tpl = null)
	{
		$params			= JComponentHelper::getParams('com_contactenhanced');
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->assignRef('params',	$params);
		
		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		//require_once JPATH_COMPONENT.'/helpers/contact.php';
		$canDo	= CEHelper::getActions();

		JToolBarHelper::title( JText::_( 'COM_CONTACTENHANCED_TOOLS_MANAGER' ), 'ce-contact' );

		if ($canDo->get('core.admin')) {
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_contactenhanced');
		}
		
	}

}
