<?php
/**
 * @package		com_contactenhanced
* @copyright	Copyright (C) 2006 - 2013 Ideal Extensions for Joomla
 * @author     	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * HTML View class for the Contact component
 *
 * @since		1.5
 */
class ContactenhancedViewContact extends JView
{
	protected $form;
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	function display($tpl = null)
	{
		$this->form		= $this->get('form');
		$this->item		= $this->get('item');
		$this->state	= $this->get('state');
		$params			= JComponentHelper::getParams('com_contactenhanced');
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		$this->assignRef('params',	$params);
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JRequest::setVar('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= CEHelper::getActions($this->item->catid, 0);
		$jversion = new JVersion();

		JToolBarHelper::title(JText::_('COM_CONTACTENHANCED_MANAGER_CONTACT'), 'ce-contact');

		// Build the actions for new and existing records.
		if ($isNew)  {
			// For new records, check the create permission.
			if ($isNew && (count($user->getAuthorisedCategories('com_contactenhanced', 'core.create')) > 0)) {
				JToolBarHelper::apply('contact.apply');
				JToolBarHelper::save('contact.save');
				if( version_compare( $jversion->getShortVersion(), '2.5', 'gt' ) ){
					JToolBarHelper::save2new('contact.save2new');
				}
			}

			JToolBarHelper::cancel('contact.cancel');
		}
		else {
			// Can't save the record if it's checked out.
			if (!$checkedOut) {
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId)) {
					JToolBarHelper::apply('contact.apply');
					JToolBarHelper::save('contact.save');

					// We can save this record, but check the create permission to see if we can return to make a new one.
					if ($canDo->get('core.create')) {
						if( version_compare( $jversion->getShortVersion(), '2.5', 'gt' ) ){
							JToolBarHelper::save2new('contact.save2new');
						}
					}
				}
			}

			// If checked out, we can still save
			if ($canDo->get('core.create')) {
				JToolBarHelper::save2copy('contact.save2copy');
			}

			JToolBarHelper::cancel('contact.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
