<?php
/**
 * @package 	mod_bt_contentslider - BT ContentSlider Module
 * @version		1.2
 * @created		Oct 2011

 * @author		BowThemes
 * @email		support@bowthems.com
 * @website		http://bowthemes.com
 * @support		Forum - http://bowthemes.com/forum/
 * @copyright	Copyright (C) 2011 Bowthemes. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
/**
 * BtK2DataSource Class  
 */
class BtK2DataSource{
	
	public $_thumbnailPath = "";
	
	public $_thumbnaiURL = "";
	
	//size of image
	public $_imagesRendered = array( 'thumbnail'=>array(),'mainImage'=>array() );	
		 
	/**
	 * Get instance of BtContentDataSource Object
	 */
	public static function getInstance(){
		static $_instance = null;
		if( !$_instance ){
			$_instance = new BtContentDataSource(); 
		}
		return $_instance;
	}

	function setThumbPathInfo( $path, $url ){
		$this->_thumbnailPath=$path;
		$this->_thumbnaiURL =$url;
		return $this;
	}
	
	public function setImagesRendered( $name=array() ){
	 	$this->_imagesRendered = $name;
		return $this;
	}		
	
	/**
	 * check K2 Existed
	 */
	public function isK2Existed(){
		return is_file( JPATH_SITE.DS.  "components" . DS . "com_k2" . DS . "k2.php" );	
	}	

	public function renderThumb( $path, $width=280, $height=150, $title='', $isThumb=true,$enable_cache=1, $cache_time=30 ){
		
		if( $isThumb ){		
			
			$path = str_replace( JURI::base(), '', $path );
			
			$imagSource = JPATH_SITE.DS. str_replace( '/', DS,  $path );			
			$imagSource = urldecode($imagSource);
			if( file_exists($imagSource)  ) {
				$tmp = explode("/", $path);
				$imageName = $width."x".$height."-".$tmp[count($tmp)-1];
				$thumbPath = $this->_thumbnailPath.$imageName;
				//var_dump(filemtime($thumbPath));
				//If file not exist or cache is out of time
				if( !file_exists($thumbPath) || filemtime($thumbPath) + 60 * $cache_time > time() /*|| $enable_cache == 0*/ ) {	
					//create thumb					
					BTImageHelper::createImage($imagSource, $thumbPath, $width, $height, $crop = true);
					
				}
				$path = $this->_thumbnaiURL.$imageName;
			} 
		}
		//return path 
    	return $path;
	}
	
	//create thumb and save link to item
	public function generateImages( $item, $isThumb = true,$enable_cache, $cache_time  ){
		//
		$item = self::parseImages( $item ); 
		
		foreach($this->_imagesRendered as $key => $value ){ 
		
			if( $item->{$key} &&  $image=$this->renderThumb($item->{$key}, $value[0], $value[1], $item->title, $isThumb, $enable_cache, $cache_time ) ){
	        	$item->{$key} = $image;
	      	
			}
		}
		return $item;
	}	

	
	/**
	 * looking for image inside the media folder.
	 * heave size XS, XL, S, M, L, Generic
	 */
	public function lookingForK2Image( $item, $size='XL' ){
		//Image
		$item->imageK2Image='';
		if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_'.$size.'.jpg'))
			$item->imageK2Image = JURI::base().'media/k2/items/cache/'.md5("Image".$item->id).'_'.$size.'.jpg';
		return $item; 
	}

	/**
	 * parser a image in the content of article.
	 *
	 * @param poiter $row .
	 * @return void
	 */
	public function parseImages( &$row ){
		//Get first
		//Get k2 item image form media/k2/
		$row  = $this->lookingForK2Image( $row );			
		if( $row->imageK2Image != '' ){
			$row->thumbnail = $row->mainImage = $row->imageK2Image;	
			return $row;
		} 
		
		//second
		//var_dump($row); die();
		
		$text =  $row->introtext;		
		$regex = "/\<img.+src\s*=\s*\"([^\"]*)\"[^\>]*\>/";
		preg_match ($regex, $text, $matches); 
		$images = (count($matches)) ? $matches : array();
		if (count($images)){
			$row->mainImage = $images[1];
			$row->thumbnail = $images[1];
		} else {
			$row->thumbnail = '';
			$row->mainImage = '';	
			}
		
		return $row;
		
		
	}
	

	/**
	 * get a subtring with the max length setting.
	 * 
	 * @param string $text;
	 * @param int $length limit characters showing;
	 * @param string $replacer;
	 * @return tring;
	 */
	public function substring($text, $length = 100, $replacer='...', $isStrips=true )
	{
		$string = $isStrips ? strip_tags( $text ):$text;
		if(strlen($string)<$length) return $string;
		$string = substr($string,0,$length);
		$string = substr($string,0,strrpos($string,' '));
		return $string.$replacer;
	}
	
	
	public static function _substrword($text, $length = 100, $replacer='...', $isStrips=true )
	{
		$string = $isStrips ? strip_tags( $text ):$text;
		
		$tmp    = explode(" ", $string);	
		
		if(count($tmp)<$length) return $string;
		
		//$string = preg_replace( "/\s+/", " ", strip_tags($item->introtext) );	   
	    
		$string = implode(" ",array_slice($tmp, 0, $length)).$replacer;
		
		return $string;
		
	}		
	

	/*----------------------------------*/


	
	/**
	 * get the list of k2 items
	 * 
	 * @param JParameter $params;
	 * @return Array
	 */
	public function getList( $params ){
		if( !self::isK2Existed() ){
			return array();
		} 
		//$mainframe = JFactory::getApplication();
		//var_dump($mainframe);
		//show_title
		//limit_title_by
		//title_max_chars
		
		//show_intro
		//limit_description_by
		//description_max_chars
		
		/* title */
		$show_title	   = $params->get( 'show_title', 1 );
		
		$titleMaxChars       = $params->get( 'title_max_chars', '100' );
		$enable_cache 	= $params->get( 'enable_cache', 1 );
		$cache_time		= $params->get( 'cache_time', 30 );
		$limit_title_by = $params->get('limit_title_by','char');
		$replacer      = $params->get('replacer','...'); 	    	
	    $isStrips = $params->get("auto_strip_tags",1);
		
		/* intro */
		$show_intro	   = $params->get( 'show_intro', 1 );
		
		$maxDesciption = $params->get( 'description_max_chars', 100 );
		
		$limitDescriptionBy = $params->get('limit_description_by','char');
		
		/* open target */
		
		$openTarget    = $params->get( 'open_target', 'parent' );		
		
		//select from
		$condition     = $this->buildConditionQuery( $params );
		//var_dump($condition);			
		
		$ordering      = $params->get( 'ordering', 'created-desc');
		
		$limit 	       = $params->get( 'limit_items',  12 );
		
		//ordering_asc -> ordering asc
		//$ordering      = str_replace( '_', '  ', $ordering );
		
		// Set ordering
	    $ordering = explode( '-', $ordering );
	    if( trim($ordering[0]) == 'rand' ){
	        $ordering = ' RAND() '; 
	    }
	    else {
	     $ordering = $ordering[0].' '.$ordering[1];	    
	    } 
		
		//var_dump($ordering);
		
		//check user access to articles		
		$my 	       = &JFactory::getUser();
		$aid	       = $my->get( 'aid', 0 );
		//var_dump($aid);
		
		//
		$isThumb       = $params->get( 'image_thumb',1);
		
		$thumbWidth    = (int)$params->get( 'thumbnail_width', 280 );
		$thumbHeight   = (int)$params->get( 'thumbnail_height', 150 );
		
		
		$isStripedTags = $params->get( 'auto_strip_tags', 0 );
		
		$extraURL 		= $params->get('open_target')!='modalbox'?'':'&tmpl=component';				
		
		$db	    = &JFactory::getDBO();
		$date   =& JFactory::getDate();
		$now    = $date->toMySQL();
		
		$dateFormat = $params->get('date_format', 'DATE_FORMAT_LC3');		
		
		$show_author= $params->get('show_author',0);
		
		require_once ( JPath::clean(JPATH_SITE.'/components/com_k2/helpers/route.php') );
		require_once ( JPath::clean(JPATH_SITE.'/components/com_k2/helpers/utilities.php') );
		
		$query = "SELECT  a.*, c.name as category_title,
						c.id as categoryid, c.alias as categoryalias, c.params as categoryparams".
				" FROM #__k2_items as a".
					" LEFT JOIN #__k2_categories c ON c.id = a.catid" ;					
			
		$query .= " WHERE a.published = 1"
					. " AND a.access >= {$aid}"
					. " AND a.trash = 0"
					. " AND c.published = 1"
					. " AND c.access >= {$aid}"
					. " AND c.trash = 0 " ;	
		if( $params->get('show_featured','1') == 2 ){
			$query.= " AND a.featured != 1";
		} elseif(  $params->get('show_featured','1') == 3 ) {
			$query.= " AND a.featured = 1";
		}
		
		$query .=  $condition . ' ORDER BY ' . $ordering;	
		$query .=  $limit ? ' LIMIT ' . $limit : '';
		
		

		//var_dump($query);die();	
		
		$db->setQuery($query);
		
		$data = $db->loadObjectlist();

		if( empty($data) ) return array();
	
		foreach( $data as $key => &$item ){	
		
			if($item->access >= $aid ) {
				//get link k2
				$item->link = JRoute::_(K2HelperRoute::getItemRoute($item->id.':'.$item->alias, $item->catid.':'.$item->categoryalias));
			} else {
				$item->link = JRoute::_('index.php?option=com_user&view=login');
			}
			
			$item->date = JHtml::_('date', $item->created, JText::_($dateFormat)); 
			
			//title cut
			if( $limit_title_by == 'word' && $titleMaxChars > 0){

				$item->title_cut = self::_substrword( $item->title, $titleMaxChars, $replacer, $isStrips  );

			} elseif ( $limit_title_by == 'char' && $titleMaxChars > 0){
			
				$item->title_cut = self::substring( $item->title, $titleMaxChars, $replacer, $isStrips  );
			
			}
			
			if( $limitDescriptionBy=='word' ){
				
				$item->description = self::_substrword( $item->introtext, $maxDesciption );	
				
			} else {
			
				$item->description = self::substring( $item->introtext, $maxDesciption );	
				
			}
			//var_dump($item); die();			
			
			
			$item->categoryLink = urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($item->catid.':'.urlencode($item->categoryalias))));
			
			
			
			//Get name author
			//If set get, else get username by userid
			if( $show_author ){
				if (! empty($item->created_by_alias)) {
					$item->author = $item->created_by_alias;
				} else {
					$author = &JFactory::getUser($item->created_by);
					$item->author = $author->name;
				}
			}	
			
			//
			$item->authorLink = JRoute::_(K2HelperRoute::getUserRoute($item->created_by));
			if($params->get('show_image')){
				$item = $this->generateImages( $item, $isThumb, $enable_cache, $cache_time );			
			}
			
									
		}		
		
		return $data;	
	}
	
	public function buildConditionQuery( $params ){
		
		$source = trim($params->get( 'source', 'k2_category' ) );
	
		if( $source == 'k2_category' ){
		
			$catids = $params->get( 'k2_category','');
			
			if( !$catids ){
				return '';
			}
			$catids = !is_array($catids) ? $catids : '"'.implode('","',$catids).'"';
			
			$condition = ' AND  a.catid IN( '.$catids.' )';
			
		} 
		else 
		{
			if( !$params->get( 'k2_article_ids','' ) ){
					return '';
			}	
			
			$ids = preg_split('/,/',$params->get( 'k2_article_ids','' ));				
			
			$tmp = array();
			
			foreach( $ids as $id ){
			
				$tmp[] = (int) trim($id);
				
			}
			
			$condition = " AND a.id IN('". implode( "','", $tmp ) ."')";
			
		}		
		
		return $condition;
	}
}
		