<?php
/**
 * @package 	mod_bt_contentslider - BT ContentSlider Module
 * @version		1.2
 * @created		Oct 2011

 * @author		BowThemes
 * @email		support@bowthems.com
 * @website		http://bowthemes.com
 * @support		Forum - http://bowthemes.com/forum/
 * @copyright	Copyright (C) 2011 Bowthemes. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
//Get to process link
require_once JPATH_SITE.'/components/com_content/helpers/route.php';
JModel::addIncludePath(JPATH_SITE.'/components/com_content/models');
require_once JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php';

/**
 * class BtContentDataSource
 */
class BtContentDataSource {
	
	public $_thumbnailPath = "";
	
	public $_thumbnaiURL = "";
	
	//size of image
	public $_imagesRendered = array( 'thumbnail'=>array(),'mainImage'=>array() );	
		 
	/**
	 * Get instance of BtContentDataSource Object
	 */
	public static function getInstance(){
		static $_instance = null;
		if( !$_instance ){
			$_instance = new BtContentDataSource(); 
		}
		return $_instance;
	}
	
	/**
	 * Set folder's path and url of thumbnail folder
	 * return $this for $Obj->fun1()->fun2();
	 */	
	function setThumbPathInfo( $path, $url ){
		$this->_thumbnailPath=$path;
		$this->_thumbnaiURL =$url;
		return $this;
	}
	
	public function setImagesRendered( $name=array() ){
	 	$this->_imagesRendered = $name;
		return $this;
	}	
	
	
	/**
	 *  check the folder is existed, if not make a directory and set permission is 755
	 *
	 * @param array $path
	 * @access public,
	 * @return boolean.
	 */
	public function renderThumb( $path, $width=280, $height=150, $title='', $isThumb=true,$enable_cache=1, $cache_time=30 ){
		
		if( $isThumb ){		
			
			$path = str_replace( JURI::base(), '', $path );
			
			$imagSource = JPATH_SITE.DS. str_replace( '/', DS,  $path );			
			$imagSource = urldecode($imagSource);
			if( file_exists($imagSource)  ) {
			
				$tmp = explode("/", $path);
				$imageName = $width."x".$height."-".$tmp[count($tmp)-1];
				$thumbPath = $this->_thumbnailPath.$imageName;
				//var_dump(filemtime($thumbPath));
				//If file not exist or cache is out of time
				if( !file_exists($thumbPath) || filemtime($thumbPath) + 60 * $cache_time > time() /*|| $enable_cache == 0*/ ) {	
					//create thumb					
					BTImageHelper::createImage($imagSource, $thumbPath, $width, $height, $crop = true);
					
				}
				$path = $this->_thumbnaiURL.$imageName;
			} 
		}
		//return path 
    	return $path;
	}
	
	/**
	 * parser a image in the content of article.
	 *
	 * @param.
	 * @return
	 */
	public static function parseImages( $row ){
	
		$text =  $row->introtext;
		
		$regex = "/\<img.+src\s*=\s*\"([^\"]*)\"[^\>]*\>/";
		preg_match ($regex, $text, $matches); 
		$images = (count($matches)) ? $matches : array();
		if (count($images)){
			$row->mainImage = $images[1];
			$row->thumbnail = $images[1];
		} else {
			$row->thumbnail = '';
			$row->mainImage = '';	
			}
		
		return $row;
	}
	
	//create thumb and save link to item
	public function generateImages( $item, $isThumb = true,$enable_cache, $cache_time  ){
		//
		$item = self::parseImages( $item ); 
		
		foreach($this->_imagesRendered as $key => $value ){ 
		
			if( $item->{$key} &&  $image=$this->renderThumb($item->{$key}, $value[0], $value[1], $item->title, $isThumb, $enable_cache, $cache_time ) ){
	        	$item->{$key} = $image;
	      	
			}
		}
		return $item;
	}	

	
 	/**
	 * Get a subtring with the max length setting.
	 * 
	 * @param string $text;
	 * @param int $length limit characters showing;
	 * @param string $replacer;
	 * @return tring;
	 */
	public static function substring( $text, $length = 100, $replacer='...', $isStrips=true )
	{
		$string = $isStrips ? strip_tags( $text ):$text;
		if(strlen($string)<$length) return $string;
		$string = substr($string,0,$length);
		return $string.$replacer;		
	}
	
	/**
	 * Get a subtring with the max length setting
	 * 
	 * @param string $text;
	 * @param int $length limit characters showing;
	 * @param string $replacer;
	 * @return tring;
	 */
	
	public static function _substr($text, $length = 100, $replacer='...', $isStrips=true )
	{
		$string = $isStrips ? strip_tags( $text ):$text;
		if(strlen($string)<$length) return $string;
		$string = substr($string,0,$length);
		$string = substr($string,0,strrpos($string,' '));
		return $string.$replacer;
	}
	
	
	/**
	 * Get a subtring with the max word setting
	 * 
	 * @param string $text;
	 * @param int $length limit characters showing;
	 * @param string $replacer;
	 * @return tring;
	 */
	
	public static function _substrword($text, $length = 100, $replacer='...', $isStrips=true )
	{
		$string = $isStrips ? strip_tags( $text ):$text;
		
		$tmp    = explode(" ", $string);	
		
		if(count($tmp)<$length) return $string;			
	    
		$string = implode(" ",array_slice($tmp, 0, $length)).$replacer;
		
		return $string;
		
	}
	
	
	/**
	 * Get List articles following to parameters
	 */
	function getList( $params ){	

		$enable_cache 	= $params->get( 'enable_cache', 1 );
			
		$cache_time		= $params->get( 'cache_time', 30 );
		
		$formatter           = $params->get( 'style_displaying', 'title' );
		
	    $titleMaxChars       = $params->get( 'title_max_chars', '100' );
		
		$limit_title_by = $params->get('limit_title_by','char');
		
	    $descriptionMaxChars = $params->get( 'description_max_chars', 100 );
		
		$limitDescriptionBy = $params->get('limit_description_by','char');
		
	    $isThumb       = $params->get( 'image_thumb',1);
		
	    $replacer      = $params->get('replacer','...'); 	    
		
	    $isStrips = $params->get("auto_strip_tags",1);
		
		$ordering      = $params->get('ordering', 'created-asc');		
	    
	    $db = JFactory::getDbo();
		
	    // Get an instance of the generic articles model
	    $model = JModel::getInstance('Articles', 'ContentModel', array('ignore_request' => true));
		
	    // Set application parameters in model
	    $app = JFactory::getApplication();
		
	    $appParams = $app->getParams();
		
	    $model->setState('params', $appParams);
		
		$model->setState('list.select', 'a.fulltext, a.id, a.title, a.alias, a.title_alias, a.introtext, a.state, a.catid, a.created, a.created_by, a.created_by_alias,' .
								' a.modified, a.modified_by,a.publish_up, a.publish_down, a.attribs, a.metadata, a.metakey, a.metadesc, a.access,' .
								' a.hits, a.featured,' .
								' LENGTH(a.fulltext) AS readmore');
	    // Set the filters based on the module params
	    
		$model->setState('list.start', 0);
	    $model->setState('list.limit', (int) $params->get('limit_items', 12));
	    $model->setState('filter.published', 1);
	
	    // Access filter
	    $access = !JComponentHelper::getParams('com_content')->get('show_noauth');
		//var_dump($access);
	    $authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		//var_dump($authorised);
	    $model->setState('filter.access', $access);
	    
		
	   $source = trim($params->get( 'source', 'category' ) );
	   //if category
	    if( $source == 'category' ){
	      // Category filter
	      $model->setState('filter.category_id', $params->get('category', array()));
		//esle article_ids
	    }else{
	      $ids = preg_split('/,/',$params->get( 'article_ids','')); 
	      $tmp = array();
	      foreach( $ids as $id ){
	        $tmp[] = (int) trim($id);
	      }
	      $model->setState('filter.article_id', $tmp);  
	    }
	
	    // User filter
	    $userId = JFactory::getUser()->get('id');
	    switch ($params->get('user_id') ) {
	      case 'by_me':
	        $model->setState('filter.author_id', (int) $userId);
	        break;
	      case 'not_me':
	        $model->setState('filter.author_id', $userId);
	        $model->setState('filter.author_id.include', false);
	        break;
	     case 0:
	        break;
	
	      default:
	        $model->setState('filter.author_id', (int) $params->get('user_id'));
	        break;
	    }
	
	    // Filter by language
	    //$model->setState('filter.language',$app->getLanguageFilter());
		
	    //  Featured switch
	    switch ( $params->get('show_featured') )  {
	      case 3:
	        $model->setState('filter.featured', 'only');
	        break;
	      case 2:
	        $model->setState('filter.featured', 'hide');
	        break;
	      default:
	        $model->setState('filter.featured', 'show');
	        break;
	    }
	
	    // Set ordering
	    $ordering = explode( '-', $ordering );
	    if( trim($ordering[0]) == 'rand' ){
	        $model->setState('list.ordering', ' RAND() '); 
	    }
	    else {
	      $model->setState('list.ordering', 'a.'.$ordering[0]);
	      $model->setState('list.direction', $ordering[1]);
	    } 
	  
	    $items = $model->getItems();

		foreach ($items as &$item) {
			
			//var_dump($item);
			
	    	$item->slug = $item->id.':'.$item->alias;
			
	      	$item->catslug = $item->catid.':'.$item->category_alias;
	    	
	      	if ($access || in_array($item->access, $authorised)) {
	        	// We know that user has the privilege to view the article
				//Item link
	        	$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
		    }
		    else {
			
		    	$item->link = JRoute::_('index.php?option=com_user&view=login');
		    }
	     	$item->date = JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC2')); 
			
			if($params->get('show_image',1)){
				$item = $this->generateImages( $item, $isThumb, $enable_cache, $cache_time );			
			}
			
	      	$item->fulltext = $item->introtext;
			
			$item->introtext   = JHtml::_('content.prepare', $item->introtext);			
	      	
			//category Link
	      	$item->categoryLink 	 = JRoute::_(ContentHelperRoute::getCategoryRoute($item->catid));
			
			if( $limit_title_by == 'word' && $titleMaxChars > 0){
				        	
				$item->title_cut = self::_substrword( $item->title, $titleMaxChars, $replacer, $isStrips  );
								
	        } elseif ( $limit_title_by == 'char' && $titleMaxChars > 0)	{
			
	        	$item->title_cut = self::substring( $item->title, $titleMaxChars, $replacer, $isStrips  );		
	      	}
			
	      	if( $limitDescriptionBy == 'word' && $descriptionMaxChars >0){
	        	
				$item->description = self::_substrword( $item->introtext, $descriptionMaxChars, $replacer, $isStrips  );
								
	        } elseif ( $limitDescriptionBy == 'char' && $descriptionMaxChars > 0){

	        	$item->description = self::substring( $item->introtext, $descriptionMaxChars, $replacer, $isStrips  );
	      	}
		}
		return $items;
	}
}

?>